/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import org.graalvm.visualvm.lib.jfluid.heap.HeapSummary;
import org.graalvm.visualvm.lib.jfluid.heap.HprofByteBuffer;

final class Summary
implements HeapSummary {
    final int totalLiveBytes;
    final int totalLiveInstances;
    final long time;
    final long totalAllocatedBytes;
    final long totalAllocatedInstances;

    Summary(HprofByteBuffer dumpBuffer, long startOffset) {
        assert (dumpBuffer.get(startOffset) == 7);
        dumpBuffer.getInt(startOffset + 1L);
        dumpBuffer.getInt(startOffset + 1L + 4L);
        this.totalLiveBytes = dumpBuffer.getInt(startOffset + 1L + 4L + 4L);
        this.totalLiveInstances = dumpBuffer.getInt(startOffset + 1L + 4L + 4L + 4L);
        this.totalAllocatedBytes = dumpBuffer.getLong(startOffset + 1L + 4L + 4L + 4L + 4L);
        this.totalAllocatedInstances = dumpBuffer.getLong(startOffset + 1L + 4L + 4L + 4L + 4L + 8L);
        this.time = dumpBuffer.getTime();
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public long getTotalAllocatedBytes() {
        return this.totalAllocatedBytes;
    }

    @Override
    public long getTotalAllocatedInstances() {
        return this.totalAllocatedInstances;
    }

    @Override
    public long getTotalLiveBytes() {
        return this.totalLiveBytes;
    }

    @Override
    public long getTotalLiveInstances() {
        return this.totalLiveInstances;
    }
}

