/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.Intervals;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsQuery;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsQueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IntervalsPrefix
implements IntervalsVariant,
IntervalsQueryVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, IntervalsPrefix> {
    @Nullable
    private final String analyzer;
    @Nonnull
    private final String prefix;
    @Nullable
    private final String useField;
    public static final JsonpDeserializer<IntervalsPrefix> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntervalsPrefix::setupIntervalsPrefixDeserializer);

    private IntervalsPrefix(Builder builder) {
        this.analyzer = builder.analyzer;
        this.prefix = ApiTypeHelper.requireNonNull(builder.prefix, this, "prefix");
        this.useField = builder.useField;
    }

    public static IntervalsPrefix of(Function<Builder, ObjectBuilder<IntervalsPrefix>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Intervals.Kind _intervalsKind() {
        return Intervals.Kind.Prefix;
    }

    @Override
    public IntervalsQuery.Kind _intervalsQueryKind() {
        return IntervalsQuery.Kind.Prefix;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nonnull
    public final String prefix() {
        return this.prefix;
    }

    @Nullable
    public final String useField() {
        return this.useField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        generator.writeKey("prefix");
        generator.write(this.prefix);
        if (this.useField != null) {
            generator.writeKey("use_field");
            generator.write(this.useField);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIntervalsPrefixDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::prefix, JsonpDeserializer.stringDeserializer(), "prefix");
        op.add(Builder::useField, JsonpDeserializer.stringDeserializer(), "use_field");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + this.prefix.hashCode();
        result = 31 * result + Objects.hashCode(this.useField);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalsPrefix other = (IntervalsPrefix)o;
        return Objects.equals(this.analyzer, other.analyzer) && this.prefix.equals(other.prefix) && Objects.equals(this.useField, other.useField);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IntervalsPrefix> {
        @Nullable
        private String analyzer;
        private String prefix;
        @Nullable
        private String useField;

        public Builder() {
        }

        private Builder(IntervalsPrefix o) {
            this.analyzer = o.analyzer;
            this.prefix = o.prefix;
            this.useField = o.useField;
        }

        private Builder(Builder o) {
            this.analyzer = o.analyzer;
            this.prefix = o.prefix;
            this.useField = o.useField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        @Nonnull
        public final Builder prefix(String value) {
            this.prefix = value;
            return this;
        }

        @Nonnull
        public final Builder useField(@Nullable String value) {
            this.useField = value;
            return this;
        }

        @Override
        @Nonnull
        public IntervalsPrefix build() {
            this._checkSingleUse();
            return new IntervalsPrefix(this);
        }
    }
}

