/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Objects;

public class CombinedKey<KRight, KLeft> {
    private final KRight foreignKey;
    private final KLeft primaryKey;

    CombinedKey(KRight foreignKey, KLeft primaryKey) {
        Objects.requireNonNull(primaryKey, "primaryKey can't be null");
        this.foreignKey = foreignKey;
        this.primaryKey = primaryKey;
    }

    public KRight foreignKey() {
        return this.foreignKey;
    }

    public KLeft primaryKey() {
        return this.primaryKey;
    }

    public int hashCode() {
        return Objects.hash(this.foreignKey, this.primaryKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedKey that = (CombinedKey)o;
        return Objects.equals(this.foreignKey, that.foreignKey) && Objects.equals(this.primaryKey, that.primaryKey);
    }

    public String toString() {
        return "CombinedKey{foreignKey=" + String.valueOf(this.foreignKey) + ", primaryKey=" + String.valueOf(this.primaryKey) + "}";
    }
}

