/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.expr.sort.EmptyIntIterator;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.charclass.CharacterClass;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntPredicateProxy;
import net.sf.saxon.z.IntRangeSet;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSetPredicate;
import net.sf.saxon.z.IntSingletonIterator;
import net.sf.saxon.z.IntSingletonSet;

public class OpCharClass
extends Operation {
    private final IntPredicateProxy predicate;

    OpCharClass(IntPredicateProxy predicate) {
        this.predicate = predicate;
    }

    public IntPredicateProxy getPredicate() {
        return this.predicate;
    }

    @Override
    public int getMatchLength() {
        return 1;
    }

    @Override
    public int matchesEmptyString() {
        return 1024;
    }

    @Override
    public CharacterClass getInitialCharacterClass(boolean caseBlind) {
        if (this.predicate instanceof CharacterClass) {
            return (CharacterClass)this.predicate;
        }
        return super.getInitialCharacterClass(caseBlind);
    }

    @Override
    public IntIterator iterateMatches(REMatcher matcher, int position) {
        UnicodeString in = matcher.search;
        if ((long)position < in.length() && this.predicate.test(in.codePointAt(position))) {
            return new IntSingletonIterator(position + 1);
        }
        return EmptyIntIterator.getInstance();
    }

    @Override
    public String display() {
        if (this.predicate instanceof IntSetPredicate) {
            IntSet s = ((IntSetPredicate)this.predicate).getIntSet();
            if (s instanceof IntSingletonSet) {
                return "" + (char)((IntSingletonSet)s).getMember();
            }
            if (s instanceof IntRangeSet) {
                StringBuilder fsb = new StringBuilder(64);
                IntRangeSet irs = (IntRangeSet)s;
                fsb.append("[");
                for (int i = 0; i < irs.getNumberOfRanges(); ++i) {
                    fsb.append((char)irs.getStartPoints()[1]);
                    fsb.append("-");
                    fsb.append((char)irs.getEndPoints()[1]);
                }
                fsb.append("[");
                return fsb.toString();
            }
            return "[....]";
        }
        return "[....]";
    }
}

