/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingestion;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.opensearch.ingestion.ShardIngestionState;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GetStateResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GetStateResponse> {
    @Nonnull
    private final Map<String, List<ShardIngestionState>> ingestionState;
    @Nullable
    private final String nextPageToken;
    @Nullable
    private final ShardStatistics shards;
    public static final JsonpDeserializer<GetStateResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetStateResponse::setupGetStateResponseDeserializer);

    private GetStateResponse(Builder builder) {
        this.ingestionState = ApiTypeHelper.unmodifiable(builder.ingestionState);
        this.nextPageToken = builder.nextPageToken;
        this.shards = builder.shards;
    }

    public static GetStateResponse of(Function<Builder, ObjectBuilder<GetStateResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, List<ShardIngestionState>> ingestionState() {
        return this.ingestionState;
    }

    @Nullable
    public final String nextPageToken() {
        return this.nextPageToken;
    }

    @Nullable
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.ingestionState)) {
            generator.writeKey("ingestion_state");
            generator.writeStartObject();
            for (Map.Entry<String, List<ShardIngestionState>> item0 : this.ingestionState.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (ShardIngestionState item1 : item0.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.nextPageToken != null) {
            generator.writeKey("next_page_token");
            generator.write(this.nextPageToken);
        }
        if (this.shards != null) {
            generator.writeKey("_shards");
            this.shards.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGetStateResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ingestionState, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(ShardIngestionState._DESERIALIZER)), "ingestion_state");
        op.add(Builder::nextPageToken, JsonpDeserializer.stringDeserializer(), "next_page_token");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.ingestionState);
        result = 31 * result + Objects.hashCode(this.nextPageToken);
        result = 31 * result + Objects.hashCode(this.shards);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetStateResponse other = (GetStateResponse)o;
        return Objects.equals(this.ingestionState, other.ingestionState) && Objects.equals(this.nextPageToken, other.nextPageToken) && Objects.equals(this.shards, other.shards);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GetStateResponse> {
        @Nullable
        private Map<String, List<ShardIngestionState>> ingestionState;
        @Nullable
        private String nextPageToken;
        @Nullable
        private ShardStatistics shards;

        public Builder() {
        }

        private Builder(GetStateResponse o) {
            this.ingestionState = Builder._mapCopy(o.ingestionState);
            this.nextPageToken = o.nextPageToken;
            this.shards = o.shards;
        }

        private Builder(Builder o) {
            this.ingestionState = Builder._mapCopy(o.ingestionState);
            this.nextPageToken = o.nextPageToken;
            this.shards = o.shards;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder ingestionState(Map<String, List<ShardIngestionState>> map) {
            this.ingestionState = Builder._mapPutAll(this.ingestionState, map);
            return this;
        }

        @Nonnull
        public final Builder ingestionState(String key, List<ShardIngestionState> value) {
            this.ingestionState = Builder._mapPut(this.ingestionState, key, value);
            return this;
        }

        @Nonnull
        public final Builder nextPageToken(@Nullable String value) {
            this.nextPageToken = value;
            return this;
        }

        @Nonnull
        public final Builder shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return this;
        }

        @Nonnull
        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        @Nonnull
        public GetStateResponse build() {
            this._checkSingleUse();
            return new GetStateResponse(this);
        }
    }
}

