/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ko.Token;
import org.apache.lucene.analysis.ko.Viterbi;
import org.apache.lucene.analysis.ko.dict.ConnectionCosts;
import org.apache.lucene.analysis.ko.dict.KoMorphData;
import org.apache.lucene.analysis.ko.dict.TokenInfoDictionary;
import org.apache.lucene.analysis.ko.dict.TokenInfoFST;
import org.apache.lucene.analysis.ko.dict.UnknownDictionary;
import org.apache.lucene.analysis.ko.dict.UserDictionary;
import org.apache.lucene.analysis.ko.tokenattributes.PartOfSpeechAttribute;
import org.apache.lucene.analysis.ko.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.morph.GraphvizFormatter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.IgnoreRandomChains;
import org.apache.lucene.util.fst.FST;

@IgnoreRandomChains(reason="LUCENE-10359: fails with incorrect offsets")
public final class KoreanTokenizer
extends Tokenizer {
    public static final DecompoundMode DEFAULT_DECOMPOUND = DecompoundMode.DISCARD;
    private static final boolean VERBOSE = false;
    private final Viterbi viterbi;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLengthAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    private final PartOfSpeechAttribute posAtt = (PartOfSpeechAttribute)this.addAttribute(PartOfSpeechAttribute.class);
    private final ReadingAttribute readingAtt = (ReadingAttribute)this.addAttribute(ReadingAttribute.class);

    public KoreanTokenizer() {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, null, DEFAULT_DECOMPOUND, false, true);
    }

    public KoreanTokenizer(AttributeFactory factory, UserDictionary userDictionary, DecompoundMode mode, boolean outputUnknownUnigrams) {
        this(factory, userDictionary, mode, outputUnknownUnigrams, true);
    }

    public KoreanTokenizer(AttributeFactory factory, UserDictionary userDictionary, DecompoundMode mode, boolean outputUnknownUnigrams, boolean discardPunctuation) {
        this(factory, TokenInfoDictionary.getInstance(), UnknownDictionary.getInstance(), ConnectionCosts.getInstance(), userDictionary, mode, outputUnknownUnigrams, discardPunctuation);
    }

    @IgnoreRandomChains(reason="Parameters are too complex to be tested")
    public KoreanTokenizer(AttributeFactory factory, TokenInfoDictionary systemDictionary, UnknownDictionary unkDictionary, ConnectionCosts connectionCosts, UserDictionary userDictionary, DecompoundMode mode, boolean outputUnknownUnigrams, boolean discardPunctuation) {
        super(factory);
        TokenInfoFST fst = systemDictionary.getFST();
        FST.BytesReader fstReader = fst.getBytesReader();
        TokenInfoFST userFST = null;
        FST.BytesReader userFSTReader = null;
        if (userDictionary != null) {
            userFST = userDictionary.getFST();
            userFSTReader = userFST.getBytesReader();
        }
        this.viterbi = new Viterbi(fst, fstReader, systemDictionary, userFST, userFSTReader, userDictionary, connectionCosts, unkDictionary, unkDictionary.getCharacterDefinition(), discardPunctuation, mode, outputUnknownUnigrams);
        this.viterbi.resetBuffer(this.input);
        this.viterbi.resetState();
    }

    public void close() throws IOException {
        super.close();
        this.viterbi.resetBuffer(this.input);
    }

    public void reset() throws IOException {
        super.reset();
        this.viterbi.resetBuffer(this.input);
        this.viterbi.resetState();
    }

    public void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.viterbi.getPos());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public boolean incrementToken() throws IOException {
        while (this.viterbi.getPending().size() == 0) {
            if (this.viterbi.isEnd()) {
                return false;
            }
            this.viterbi.forward();
        }
        Token token = (Token)((Object)this.viterbi.getPending().remove(this.viterbi.getPending().size() - 1));
        int length = token.getLength();
        this.clearAttributes();
        assert (length > 0);
        this.termAtt.copyBuffer(token.getSurfaceForm(), token.getOffset(), length);
        this.offsetAtt.setOffset(this.correctOffset(token.getStartOffset()), this.correctOffset(token.getEndOffset()));
        this.posAtt.setToken(token);
        this.readingAtt.setToken(token);
        this.posIncAtt.setPositionIncrement(token.getPositionIncrement());
        this.posLengthAtt.setPositionLength(token.getPositionLength());
        return true;
    }

    public void setGraphvizFormatter(GraphvizFormatter<KoMorphData> dotOut) {
        this.viterbi.setGraphvizFormatter(dotOut);
    }

    public static enum DecompoundMode {
        NONE,
        DISCARD,
        MIXED;

    }
}

