/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devui;

import io.quarkus.arc.deployment.devui.Link;
import io.quarkus.arc.deployment.devui.Node;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class DependencyGraph {
    static final DependencyGraph EMPTY = new DependencyGraph(Set.of(), Set.of());
    public final Set<Node> nodes;
    public final Set<Link> links;
    public final int maxLevel;

    public DependencyGraph(Set<Node> nodes, Set<Link> links) {
        this.nodes = nodes;
        this.links = links;
        this.maxLevel = links.stream().mapToInt(l -> l.level).max().orElse(0);
    }

    DependencyGraph forLevel(int level) {
        return this.filterLinks(link -> link.level <= level);
    }

    DependencyGraph filterLinks(Predicate<Link> predicate) {
        HashSet<Link> newLinks = new HashSet<Link>();
        HashSet<Node> newNodes = new HashSet<Node>();
        HashSet<String> usedIds = new HashSet<String>();
        for (Link link : this.links) {
            if (!predicate.test(link)) continue;
            newLinks.add(link);
            usedIds.add(link.source);
            usedIds.add(link.target);
        }
        for (Node node : this.nodes) {
            if (!usedIds.contains(node.getId())) continue;
            newNodes.add(node);
        }
        return new DependencyGraph(newNodes, newLinks);
    }
}

