/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.Locking;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class TimesTenSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public TimesTenSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, Locking.FollowOn followOnStrategy) {
        if (followOnStrategy == Locking.FollowOn.FORCE) {
            return AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        AbstractSqlAstTranslator.LockStrategy strategy = AbstractSqlAstTranslator.LockStrategy.CLAUSE;
        if (this.getQueryPartStack().findCurrentFirst(part -> part instanceof QueryGroup ? part : null) != null) {
            if (followOnStrategy == Locking.FollowOn.DISALLOW) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported!");
            }
            strategy = followOnStrategy != Locking.FollowOn.IGNORE ? AbstractSqlAstTranslator.LockStrategy.NONE : AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        return strategy;
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        this.renderRowsToClause((QuerySpec)this.getQueryPartStack().getCurrent());
        super.visitSqlSelections(selectClause);
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, offset);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    protected void renderRowsToClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderRowsToClause((Expression)this.getOffsetParameter(), (Expression)this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType((QueryPart)querySpec);
            this.renderRowsToClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderRowsToClause(Expression offsetClauseExpression, Expression fetchClauseExpression) {
        Stack clauseStack = this.getClauseStack();
        if (offsetClauseExpression == null && fetchClauseExpression != null) {
            this.appendSql("first ");
            clauseStack.push((Object)Clause.FETCH);
            try {
                this.renderFetchExpression(fetchClauseExpression);
            }
            finally {
                clauseStack.pop();
            }
        }
        if (offsetClauseExpression != null) {
            this.appendSql("rows ");
            clauseStack.push((Object)Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetClauseExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(" to ");
            clauseStack.push((Object)Clause.FETCH);
            try {
                if (fetchClauseExpression != null) {
                    this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, -1);
                } else {
                    this.appendSql(Integer.MAX_VALUE);
                }
            }
            finally {
                clauseStack.pop();
            }
        }
        this.appendSql(' ');
    }
}

