/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.StaticHookDefinition;
import io.cucumber.java.AbstractGlueDefinition;
import io.cucumber.java.AfterAll;
import io.cucumber.java.BeforeAll;
import io.cucumber.java.InvalidMethodSignatureException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

final class JavaStaticHookDefinition
extends AbstractGlueDefinition
implements StaticHookDefinition {
    private final int order;

    JavaStaticHookDefinition(Method method, int order, Lookup lookup) {
        super(JavaStaticHookDefinition.requireValidMethod(method), lookup);
        this.order = order;
    }

    private static Method requireValidMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 0) {
            throw JavaStaticHookDefinition.createInvalidSignatureException(method);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw JavaStaticHookDefinition.createInvalidSignatureException(method);
        }
        Type returnType = method.getGenericReturnType();
        if (!Void.class.equals((Object)returnType) && !Void.TYPE.equals(returnType)) {
            throw JavaStaticHookDefinition.createInvalidSignatureException(method);
        }
        return method;
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(BeforeAll.class).addAnnotation(AfterAll.class).addSignature("public static void before_or_after_all()").build();
    }

    public void execute() {
        this.invokeMethod(new Object[0]);
    }

    public int getOrder() {
        return this.order;
    }
}

